﻿--[[

-- Atlas Data (Traditional Chinese)
-- Translated and maintained by Arith Hsu
-- arithmandarjp at yahoo.co.jp
-- Special thanks for Alfred and his website "Alfred's WoW Treasure BOX"
-- http://statue.sayya.org/wowdb/index.php
--
-- Last Updated: 8/09/2007

--]]
if (GetLocale() == 	"zhTW") then

--[[
rep.lua
This file defines the loot tables for all the rep factions.
]]

--Need to invoke the constants file 
local AL = AceLibrary("AceLocale-2.2"):new("AtlasLoot");

--All rep loot tables go in this table
AtlasLoot_Data["AtlasLootRepItems"] = {
    EmptyInstance = {};
    
    Aldor1 = {
        { 0, "Spell_Holy_SealOfSalvation", "=q6=#r2#", "" },
        { 23149, "INV_Scroll_06", "=q2=設計圖:微光的黃金卓奈石", "=ds=#p12# (305)" },
        { 23601, "INV_Scroll_03", "=q1=設計圖:暗影毀滅護腕", "=ds=#p2# (350)" },
        { 30842, "INV_Scroll_03", "=q1=烈焰之心護腕", "=ds=#p8# (350)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "Spell_Holy_SealOfSalvation", "=q6=#r3#", "" },
        { 29129, "INV_Chest_Cloth_19", "=q3=隱士長袍", "=ds=#a1#, #s5#" },
        { 28881, "Spell_Holy_SealOfWisdom", "=q2=戒律銘文", "=ds=#s3# #e17#" },
        { 28878, "Spell_Holy_SealOfSalvation", "=q2=信念銘文", "=ds=#s3# #e17#" },
        { 28885, "Spell_Holy_FistOfJustice", "=q2=復仇銘文", "=ds=#s3# #e17#" },
        { 28882, "Spell_Holy_GreaterBlessingofSanctuary", "=q2=守衛銘文", "=ds=#s3# #e17#" },
        { 23145, "INV_Scroll_06", "=q2=設計圖:高貴的暗影卓奈石", "=ds=#p12# (305)" },
        { 23603, "INV_Scroll_03", "=q1=設計圖:暗影毀滅手套", "=ds=#p2# (360)" },
        { 29704, "INV_Scroll_03", "=q1=圖樣:暗影守衛腰帶", "=ds=#p7# (350)" },
        { 29693, "INV_Scroll_03", "=q1=圖樣:暗鱗腰帶", "=ds=#p7# (350)" },
        { 30843, "INV_Scroll_03", "=q1=圖樣:烈焰之心護手", "=ds=#p8# (360)" },
        { 24293, "INV_Scroll_03", "=q1=圖樣:銀色法術絲線", "=ds=#p8# (335)" },
        };
    
    Aldor2 = {
        { 0, "Spell_Holy_SealOfSalvation", "=q6=#r4#", "" },
        { 29127, "INV_Chest_Plate02", "=q3=復仇者鎖甲", "=ds=#s5#, #a4#" },
        { 29128, "INV_Jewelry_Ring_48Naxxramas", "=q3=光明看護者指環", "=ds=#s13#" },
        { 29130, "INV_Staff_14", "=q3=奧奇奈法杖", "=ds=#w9#" },
        { 24177, "INV_Scroll_05", "=q3=設計圖:闇盡吊飾", "=ds=#p12# (360)" },
        { 23604, "INV_Scroll_03", "=q1=設計圖:暗影毀滅胸甲", "=ds=#p2# (365)" },
        { 29703, "INV_Scroll_03", "=q1=圖樣:暗影守衛長靴", "=ds=#p7# (350)" },
        { 29691, "INV_Scroll_03", "=q1=圖樣:暗鱗長靴", "=ds=#p7# (350)" },
        { 25721, "INV_Scroll_03", "=q1=圖樣:復仇者護甲片", "=ds=#p7# (325)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "Spell_Holy_SealOfSalvation", "=q6=#r5#", "" },
        { 29123, "INV_Jewelry_Amulet_04", "=q4=光明先驅者徽章", "=ds=#s2#" },
        { 29124, "INV_Sword_Draenei_01", "=q4=復仇者佩劍", "=ds=#h1#, #w10#" },
        { 28886, "Spell_Holy_SealOfWisdom", "=q3=強效紀律銘文", "=ds=#s3# #e17#" },
        { 28887, "Spell_Holy_GreaterBlessingofSalvation", "=q3=強效信念銘文", "=ds=#s3# #e17#" },
        { 28888, "Spell_Holy_GreaterBlessingofKings", "=q3=強效復仇銘文", "=ds=#s3# #e17#" },
        { 28889, "Spell_Holy_BlessingOfProtection", "=q3=強效守護銘文", "=ds=#s3# #e17#" },
        { 23602, "INV_Scroll_03", "=q1=設計圖:暗影毀滅頭盔", "=ds=#p2# (355)" },
        { 29702, "INV_Scroll_03", "=q1=圖樣:暗影守衛護腿", "=ds=#p7# (350)" },
        { 29689, "INV_Scroll_03", "=q1=圖樣:暗鱗護腿", "=ds=#p7# (350)" },
        { 24295, "INV_Scroll_03", "=q1=圖樣:金色法術絲線", "=ds=#p8# (375)" },
        { 30844, "INV_Scroll_03", "=q1=圖樣:烈焰之心外衣", "=ds=#p8# (370)" },
        { 31779, "INV_Shirt_GuildTabard_01", "=q1=奧多爾大衣", "=ds=#s7#" },
        };

    AQBroodRings = {
        { 0, "INV_Jewelry_Ring_40", "=q6="..AL["Path of the Conqueror"], "" },
       	{ 21201, "INV_Jewelry_Ring_40", "=q4=青銅龍軍團的徽記之戒", "=ds=#s13#, =q1=#r1#" },
       	{ 21202, "INV_Jewelry_Ring_40", "=q4=青銅龍軍團的徽記之戒", "=ds=#s13#, =q1=#r2#" },
       	{ 21203, "INV_Jewelry_Ring_40", "=q4=青銅龍軍團的徽記之戒", "=ds=#s13#, =q1=#r3#" },
       	{ 21204, "INV_Jewelry_Ring_40", "=q4=青銅龍軍團的徽記之戒", "=ds=#s13#, =q1=#r4#" },
       	{ 21205, "INV_Jewelry_Ring_40", "=q4=青銅龍軍團的徽記之戒", "=ds=#s13#, =q1=#r5#" },
       	{ 0,"","","" },
       	{ 0, "INV_Jewelry_Ring_40", "=q6="..AL["Path of the Invoker"], "" },
       	{ 21206, "INV_Jewelry_Ring_40", "=q4=青銅龍軍團的徽記之戒", "=ds=#s13#, =q1=#r1#" },
       	{ 21207, "INV_Jewelry_Ring_40", "=q4=青銅龍軍團的徽記之戒", "=ds=#s13#, =q1=#r2#" },
       	{ 21208, "INV_Jewelry_Ring_40", "=q4=青銅龍軍團的徽記之戒", "=ds=#s13#, =q1=#r3#" },
       	{ 21209, "INV_Jewelry_Ring_40", "=q4=青銅龍軍團的徽記之戒", "=ds=#s13#, =q1=#r4#" },
        { 21210, "INV_Jewelry_Ring_40", "=q4=青銅龍軍團的徽記之戒", "=ds=#s13#, =q1=#r5#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_Jewelry_Ring_40", "=q6="..AL["Path of the Protector"], "" },
        { 21196, "INV_Jewelry_Ring_40", "=q4=青銅龍軍團的徽記之戒", "=ds=#s13#, =q1=#r1#" },
        { 21197, "INV_Jewelry_Ring_40", "=q4=青銅龍軍團的徽記之戒", "=ds=#s13#, =q1=#r2#" },
        { 21198, "INV_Jewelry_Ring_40", "=q4=青銅龍軍團的徽記之戒", "=ds=#s13#, =q1=#r3#" },
        { 21199, "INV_Jewelry_Ring_40", "=q4=青銅龍軍團的徽記之戒", "=ds=#s13#, =q1=#r4#" },
        { 21200, "INV_Jewelry_Ring_40", "=q4=青銅龍軍團的徽記之戒", "=ds=#s13#, =q1=#r5#" },
        };
    
    Argent1 = {
        { 22689, "INV_Helmet_13", "=q3=聖化皮帽", "=ds=#s1#, #a2#" },
        { 22690, "INV_Pants_03", "=q3=瘟疫獵人護腿", "=ds=#s11#, #a3#" },
        { 22681, "INV_Jewelry_Ring_33", "=q3=虔誠指環", "=ds=#s13#" },
        { 22680, "INV_Jewelry_Ring_01", "=q3=堅定指環", "=ds=#s13#" },
        { 22688, "INV_Weapon_ShortBlade_03", "=q3=法雷盟的最後計畫", "=ds=#h3#, #w4#" },
        { 22679, "INV_Misc_Bag_17", "=q3=補給袋", "=ds=#m14# #e1#" },
        { 0, "", "", "" },
        { 22638, "Spell_Shadow_AntiShadow", "=q3=烈焰套裝", "=ds=#s1# #e17#" },
        { 0, "", "", "" },  
        { 22523, "INV_Misc_Token_ArgentDawn", "=q2=黎明徽記", "=ds=#m17#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 22667, "INV_Bracer_12", "=q4=希望護腕", "=ds=#s8#, #a1#" },
        { 22668, "INV_Bracer_04", "=q4=狡猾護腕", "=ds=#s8#, #a2#" },
        { 22657, "INV_Jewelry_Amulet_04", "=q4=黎明護符", "=ds=#s2#" },
        { 22659, "INV_Jewelry_Amulet_04", "=q4=黎明勳章", "=ds=#s2#" },
        { 22678, "INV_Misc_Gem_Pearl_04", "=q4=權勢護符", "=ds=#s14#" },
        { 22656, "INV_Weapon_Rifle_06", "=q4=淨化者", "=ds=#w5#" },
        { 0, "", "", "" },
        { 22636, "Spell_Frost_FrostShock", "=q3=冰霜守衛者", "=ds=#s1# #e17#" },
        { 0, "", "", "" },  
        { 22524, "INV_Misc_Token_ScarletCrusade", "=q2=十字軍徽記", "=ds=#m17#" },
        };

    Argent2 = {
        { 0, "INV_Jewelry_Talisman_08", "=q6=#r2#", "" },
        { 13724, "INV_Misc_Food_33", "=q1=可口的魔法點心", "=ds=#e3#" },
        { 0, "", "", "" },
        { 0, "INV_Jewelry_Talisman_08", "=q6=#r3#", "" },
        { 13482, "INV_Scroll_06", "=q2=配方:點氣成火", "=ds=#p1# (275)" },
        { 19203, "INV_Scroll_03", "=q1=設計圖:黎明束腰", "=ds=#p2# (290)" },
        { 19446, "INV_Misc_Note_01", "=q1=公式:附魔護腕 - 法力恢復", "=ds=#p4# (290)" },
        { 19442, "INV_Scroll_03", "=q1=配方:強效抗毒藥劑", "=ds=#p6# (300)" },
        { 19328, "INV_Scroll_03", "=q1=圖樣:黎明皮靴", "=ds=#p7# (290)" },
        { 19216, "INV_Scroll_03", "=q1=圖樣:銀色長靴", "=ds=#p8# (290)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 12844, "INV_Jewelry_Talisman_08", "=q2=銀色黎明勇氣勳章", "=ds=#m17#" },
        { 0, "", "", "" },
        { 0, "INV_Jewelry_Talisman_08", "=q6=#r4#", "" },
        { 18171, "Spell_Holy_WordFortitude", "=q2=祕法黎明襯肩", "=ds=#s3# #e17#" },
        { 18169, "Spell_Fire_FlameShock", "=q2=火焰黎明襯肩", "=ds=#s3# #e17#" },
        { 18170, "Spell_Frost_FrostShock", "=q2=冰霜黎明襯肩", "=ds=#s3# #e17#" },
        { 18172, "Spell_Nature_ProtectionformNature", "=q2=自然黎明襯肩", "=ds=#s3# #e17#" },
        { 18173, "Spell_Shadow_RagingScream", "=q2=暗影黎明襯肩", "=ds=#s3# #e17#" },
        { 19205, "INV_Scroll_03", "=q1=設計圖:黎明手套", "=ds=#p2# (300)" },
        { 19447, "INV_Misc_Note_01", "=q1=公式:附魔護腕 - 治療", "=ds=#p4# (300)" },
        { 19329, "INV_Scroll_03", "=q1=圖樣:金色黎明襯肩", "=ds=#p7# (300)" },
        { 19217, "INV_Scroll_03", "=q1=圖樣:銀色護肩", "=ds=#p8# (300)" },
        { 13810, "INV_Misc_Food_41", "=q1=神聖太陽果", "=ds=#e3#" },
        { 13813, "INV_Drink_16", "=q1=神聖太陽果汁", "=ds=#e4#" },
        { 0, "", "", "" },
        { 0, "INV_Jewelry_Talisman_08", "=q6=#r5#", "" },
        { 18182, "INV_Misc_Gem_Variety_02", "=q2=多彩黎明襯肩", "=ds=#s3# #e17#" },
        };
        
    Ashtongue1 = {
        { 0, "INV_Misc_Gem_Pearl_05", "=q6=#r2#", "" },
        { 32444, "INV_Scroll_03", "=q1=設計圖:影堅腰帶", "=ds=#p2# (375)" },
        { 32442, "INV_Scroll_03", "=q1=設計圖:影堅護腕", "=ds=#p2# (375)" },
        { 32436, "INV_Scroll_03", "=q1=圖樣:救贖之魂腰帶", "=ds=#p7# (375)" },
        { 32435, "INV_Scroll_03", "=q1=圖樣:救贖之魂護腿", "=ds=#p7# (375)" },
        { 32430, "INV_Scroll_03", "=q1=圖樣:束縛之魂護腕", "=ds=#p7# (375)" },
        { 32429, "INV_Scroll_03", "=q1=圖樣:束縛之魂長靴", "=ds=#p7# (375)" },
        { 32440, "INV_Scroll_03", "=q1=圖樣:靈魂守護腰帶", "=ds=#p8# (375)" },
        { 32438, "INV_Scroll_03", "=q1=圖樣:靈魂守護護腕", "=ds=#p8# (375)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Gem_Pearl_05", "=q6=#r3#", "" },
        { 32443, "INV_Scroll_03", "=q1=設計圖:影堅護腿", "=ds=#p2# (375)" },
        { 32441, "INV_Scroll_03", "=q1=設計圖:影堅戰靴", "=ds=#p2# (375)" },
        { 32433, "INV_Scroll_03", "=q1=圖樣:救贖之魂皮鞋", "=ds=#p7# (375)" },
        { 32434, "INV_Scroll_03", "=q1=圖樣:救贖之魂護腕", "=ds=#p7# (375)" },
        { 32431, "INV_Scroll_03", "=q1=圖樣:束縛之魂護脛", "=ds=#p7# (375)" },
        { 32432, "INV_Scroll_03", "=q1=圖樣:束縛之魂腰帶", "=ds=#p7# (375)" },
        { 32447, "INV_Scroll_03", "=q1=圖樣:夜幕之終", "=ds=#p8# (375)" },
        { 32439, "INV_Scroll_03", "=q1=圖樣:靈魂守護護腿", "=ds=#p8# (375)" },
        { 32437, "INV_Scroll_03", "=q1=圖樣:靈魂守護便鞋", "=ds=#p8# (375)" },
        }; 

    Ashtongue2 = {
	{ 0, "INV_Misc_Gem_Pearl_05", "=q6=#r5#", "" },
        { 32488, "INV_Misc_Gem_Pearl_05", "=q4=灰舌洞察護符", "=ds=#s14#, =q1=#m1# =ds=#c3#" },
        { 32490, "INV_Misc_Gem_Pearl_05", "=q4=灰舌銳敏護符", "=ds=#s14#, =q1=#m1# =ds=#c5#" },
        { 32485, "INV_Jewelry_Necklace_18", "=q4=灰舌勇氣護符", "=ds=#s14#, =q1=#m1# =ds=#c9#" },
        { 32487, "INV_Misc_Gem_Pearl_05", "=q4=灰舌迅捷護符", "=ds=#s14#, =q1=#m1# =ds=#c2#" },
        { 32491, "INV_Misc_Gem_Pearl_05", "=q4=灰舌視覺護符", "=ds=#s14#, =q1=#m1# =ds=#c7#" },
        { 32489, "INV_Misc_Gem_Pearl_05", "=q4=灰舌熱誠護符", "=ds=#s14#, =q1=#m1# =ds=#c4#" },
        { 32486, "INV_Misc_Gem_Pearl_05", "=q4=灰舌平衡護符", "=ds=#s14#, =q1=#m1# =ds=#c1#" },
        { 32492, "INV_Misc_Gem_Pearl_05", "=q4=灰舌致命護符", "=ds=#s14#, =q1=#m1# =ds=#c6#" },
        { 32493, "INV_Misc_Gem_Pearl_05", "=q4=灰舌暗影護符", "=ds=#s14#, =q1=#m1# =ds=#c8#" },
        }; 

    Bloodsail1 = {
        { 0, "INV_Helmet_66", "=q6=#r1#", "" },
        { 22742, "INV_Shirt_08", "=q1=血帆襯衣", "=ds=#s5#" },
        { 22743, "INV_Misc_Bandana_03", "=q1=血帆腰帶", "=ds=#s10#" },
        { 22745, "INV_Pants_Cloth_02", "=q1=血帆短褲", "=ds=#s11#" },
        { 22744, "INV_Boots_05", "=q1=血帆皮靴", "=ds=#s12#" },
        { 0, "", "", "" },
        { 0, "INV_Helmet_66", "=q6=#r2#", "" },
        { 12185, "INV_Helmet_66", "=q2=血帆艦長之帽", "=ds=#s1#, #a1#" },
        };

    Cenarion1 = {
        { 22209, "INV_Scroll_03", "=q1=設計圖:厚重黑曜石腰帶", "=ds=#p2# (300)" },
        { 22768, "INV_Scroll_03", "=q1=設計圖:鐵藤腰帶", "=ds=#p2# (300)" },
        { 20732, "INV_Misc_Note_01", "=q1=公式:附魔披風 - 強效火焰抗性", "=ds=#p4# (300)" },
        { 22769, "INV_Scroll_03", "=q1=圖樣:木藤腰帶", "=ds=#p7# (300)" },
        { 20509, "INV_Scroll_03", "=q1=圖樣:沙行者護腕", "=ds=#p7# (300)" },
        { 20506, "INV_Scroll_03", "=q1=圖樣:飛火護腕", "=ds=#p7# (300)" },
        { 22772, "INV_Scroll_03", "=q1=圖樣:森林襯肩", "=ds=#p8# (300)" },
        { 22310, "INV_Scroll_03", "=q1=圖樣:塞納里奧草藥包", "=ds=#p8# (275)" },
        { 0, "", "", "" },
        { 20802, "INV_Jewelry_Talisman_06", "=q2=塞納里奧作戰徽章", "=ds=#m17#" },
        { 20800, "INV_Jewelry_Necklace_16", "=q2=塞納里奧後勤徽章", "=ds=#m17#" },
        { 21515, "INV_Jewelry_Necklace_14", "=q2=雷姆洛斯印記", "=ds=#m17#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_QirajIdol_Amber", "=q6=#j8#", "" },
        { 21187, "INV_Misc_Cape_07", "=q3=地紋披風", "", "", "5", "#ccombat#", "3", "#clogistics#", "7", "#ctactical#" },
        { 21178, "INV_Gauntlets_18", "=q3=土靈力量手套", "", "", "5", "#ccombat#", "3", "#clogistics#", "7", "#ctactical#" },
        { 21179, "INV_Jewelry_Ring_18", "=q3=大地憤怒指環", "", "", "5", "#ccombat#", "3", "#clogistics#", "7", "#ctactical#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 20801, "INV_Jewelry_Amulet_02", "=q2=塞納里奧戰術徽章", "=ds=#m17#" },
        { 21508, "INV_Jewelry_Necklace_12", "=q2=塞納留斯印記", "=ds=#m17#" },
        };
    
    Cenarion2 = {
        { 22767, "INV_Scroll_03", "=q1=設計圖:鐵藤護手", "=ds=#p2# (300)" },
        { 22214, "INV_Scroll_03", "=q1=設計圖:輕巧黑曜石腰帶", "=ds=#p2# (300)" },
        { 20733, "INV_Misc_Note_01", "=q1=公式:附魔披風 - 強效自然抗性", "=ds=#p4# (300)" },
        { 22770, "INV_Scroll_03", "=q1=圖樣:木藤靴子", "=ds=#p7# (300)" },
        { 20510, "INV_Scroll_03", "=q1=圖樣:沙行者護手", "=ds=#p7# (300)" }, 
        { 20507, "INV_Scroll_03", "=q1=圖樣:飛火護手", "=ds=#p7# (300)" },
        { 22773, "INV_Scroll_03", "=q1=圖樣:森林環冠", "=ds=#p8# (300)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_QirajIdol_Amber", "=q6=#j8#", "" },
        { 21183, "INV_Chest_Cloth_06", "=q3=大地能量外套", "", "", "7", "#ccombat#", "4", "#clogistics#", "4", "#ctactical#" },
        { 21182, "INV_Jewelry_Ring_19", "=q3=大地力量指環", "", "", "7", "#ccombat#", "4", "#clogistics#", "4", "#ctactical#" },
        { 21181, "INV_Misc_Herb_02", "=q3=大地之握", "", "", "7", "#ccombat#", "4", "#clogistics#", "4", "#ctactical#" },
        };
    
    Cenarion3 = {
        { 22766, "INV_Scroll_03", "=q1=設計圖:鐵藤胸甲", "=ds=#p2# (300)" },
        { 22219, "INV_Scroll_03", "=q1=設計圖:鋸齒黑曜石之盾", "=ds=#p2# (300)" },
        { 22771, "INV_Scroll_03", "=q1=圖樣:木藤頭盔", "=ds=#p7# (300)" },
        { 20511, "INV_Scroll_03", "=q1=圖樣:沙行者胸甲", "=ds=#p7# (300)" },
        { 20508, "INV_Scroll_03", "=q1=圖樣:飛火胸甲", "=ds=#p7# (300)" },
        { 22683, "INV_Scroll_03", "=q1=圖樣:蓋亞護腰", "=ds=#p8# (300)" },
        { 22312, "INV_Scroll_03", "=q1=圖樣:塞納留斯的背包", "=ds=#p8# (300)" },
        { 22774, "INV_Scroll_03", "=q1=圖樣:森林外套", "=ds=#p8# (300)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_QirajIdol_Amber", "=q6=#j8#", "" },
        { 21186, "INV_Bracer_12", "=q4=岩石怒火護腕", "", "", "15", "#ccombat#", "20", "#clogistics#", "17", "#ctactical#", "1", "#cremulos#" },
        { 21184, "INV_Bracer_07", "=q4=深岩護腕", "", "", "15", "#ccombat#", "20", "#clogistics#", "17", "#ctactical#", "1", "#cremulos#" },
        { 21189, "INV_Jewelry_Ring_41", "=q4=塞納留斯之力", "", "", "15", "#ccombat#", "20", "#clogistics#", "17", "#ctactical#", "1", "#cremulos#" },
        { 21185, "INV_Misc_Gem_Pearl_06", "=q4=大地寧靜寶珠", "", "", "15", "#ccombat#", "20", "#clogistics#", "17", "#ctactical#", "1", "#cremulos#" },
        };
        
    Cenarion4 = {
        { 22221, "INV_Scroll_03", "=q1=設計圖:黑曜石鎖甲外套", "=ds=#p2# (300)" },
        { 20382, "INV_Scroll_03", "=q1=圖樣:夢幻龍鱗胸甲", "=ds=#p7# (300)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_QirajIdol_Amber", "=q6=#j8#", "" },
        { 21190, "INV_Jewelry_Ring_40", "=q4=塞納留斯之怒", "", "", "15", "#ccombat#", "20", "#clogistics#", "20", "#ctactical#", "1", "#ccenarius#" },
        { 21180, "Spell_Nature_AbolishMagic", "=q4=大地之擊", "", "", "15", "#ccombat#", "20", "#clogistics#", "20", "#ctactical#", "1", "#ccenarius#" },
        { 21188, "INV_Hammer_23", "=q4=塞納留斯之拳", "", "", "15", "#ccombat#", "20", "#clogistics#", "20", "#ctactical#", "1", "#ccenarius#" },        
        };   
         
    CExpedition1 = {
        { 0, "INV_Misc_Ammo_Arrow_02", "=q6=#r2#", "" },
        { 25737, "INV_Scroll_05", "=q3=圖樣:重型裂蹄長靴", "=ds=#p7# (355)" },
        { 24417, "INV_Misc_Ammo_Arrow_05", "=q2=斥侯之箭", "=ds=#w17#" },
        { 23814, "INV_Scroll_03", "=q1=結構圖:綠色煙霧照明彈", "=ds=#p5# (335)" },
        { 24429, "INV_Enchant_EssenceAstralSmall", "=q1=遠征隊照明彈", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Ammo_Arrow_02", "=q6=#r3#", "" },
        { 25838, "INV_Chest_Leather_08", "=q3=守衛者外衣", "=ds=#s5#, #a2#" },
        { 25836, "INV_Mace_11", "=q3=保衛者木槌", "=ds=#h3#, #w6#" },
        { 25835, "INV_Staff_31", "=q3=探險者的手杖", "=ds=#w9#" },
        { 25735, "INV_Scroll_05", "=q3=圖樣:重型裂蹄背心", "=ds=#p7# (360)" },
        { 25736, "INV_Scroll_05", "=q3=圖樣:重型裂蹄護腿", "=ds=#p7# (355)" },
        { 29194, "Spell_Nature_ProtectionformNature", "=q2=自然防護雕像", "#s1# #e17#" },
        { 25869, "INV_Scroll_03", "=q1=配方:轉化大地風暴鑽石", "=ds=#p1# (350)" },
        { 32070, "INV_Scroll_03", "=q1=配方:地化藥劑", "=ds=#p1# (320)" },
        { 23618, "INV_Scroll_03", "=q1=設計圖:艾曼泰磨刀石", "=ds=#p2# (350)" },
        { 28632, "INV_Scroll_03", "=q1=設計圖:艾曼泰平衡石", "=ds=#p2# (350)" },
        { 25526, "INV_Scroll_03", "=q1=設計圖:強效防護符文", "=ds=#p2# (350)" },
        { 29720, "INV_Scroll_03", "=q1=圖樣:裂蹄皮護腿片", "=ds=#p7# (335)" },
        };
        
    CExpedition2 = {
        { 0, "INV_Misc_Ammo_Arrow_02", "=q6=#r4#", "" },
        { 31392, "INV_Scroll_04", "=q4=設計圖:野性看守者頭盔", "=ds=#p2# (375)" },
        { 31391, "INV_Scroll_04", "=q4=設計圖:野性看守者護腿", "=ds=#p2# (375)" },
        { 29174, "INV_Helmet_34", "=q3=觀察者兜帽", "=ds=#s1#, #a1#" },
        { 29173, "INV_Jewelry_Necklace_06", "=q3=狂野之力", "=ds=#s2#" },
        { 31949, "INV_Misc_Ammo_Arrow_02", "=q3=守衛者之箭", "=ds=#w17#" },
        { 24183, "INV_Scroll_05", "=q3=設計圖:夜眼石獵豹", "=ds=#p12# (370)" },
        { 29192, "Ability_Druid_DemoralizingRoar", "=q2=殘爆雕像", "=ds=#s1# #e17#" },
        { 22918, "INV_Scroll_06", "=q2=配方:原始之水轉化原始空氣", "=ds=#p1# (350)" },
        { 28271, "INV_Misc_Note_01", "=q2=公式:附魔手套 - 法術打擊", "=ds=#p4# (360)" },
        { 30623, "INV_Misc_Key_13", "=q1=倉庫之鑰", "=ds=#e9#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Ammo_Arrow_02", "=q6=#r5#", "" },
        { 29170, "INV_Misc_Orb_01", "=q4=喚風者寶珠", "=ds=#s15#" },
        { 29172, "INV_Jewelry_Ring_51Naxxramas", "=q4=艾斯炎的禮物", "=ds=#s13#" },
        { 29171, "INV_Hammer_10", "=q4=大地看守者", "=ds=#h2#, #w6#" },
        { 31390, "INV_Scroll_04", "=q4=設計圖:野性看守者胸甲", "=ds=#p2# (375)" },
        { 31402, "INV_Scroll_04", "=q4=設計圖:自然守衛", "=ds=#p12# (375)" },
        { 33149, "INV_Misc_Note_01", "=q3=公式:附魔披風 - 潛行", "=ds=#p4# (300) (Patch 2.2)" },
        { 31356, "INV_Scroll_06", "=q2=配方:智慧精煉藥水", "=ds=#p1# (300)" },
        { 22922, "INV_Scroll_06", "=q1=配方:極強效自然防護藥水", "=ds=#p1# (360)" },
        { 29721, "INV_Scroll_03", "=q1=圖樣:地獄裂縫護腿片", "=ds=#p7# (365)" },
        { 31804, "INV_Shirt_GuildTabard_01", "=q1=塞納里奧遠征外衣", "=ds=#s7#" },
        };
        
    Consortium1 = {
        { 0, "INV_Weapon_Shortblade_31", "=q6=#r2#", "" },
        { 25732, "INV_Scroll_05", "=q3=圖樣:惡魔皮手套", "=ds=#p7# (340)" },
        { 28274, "INV_Misc_Note_01", "=q2=公式:附魔披風 - 法術穿透", "=ds=#p4# (325)" },
        { 23146, "INV_Scroll_06", "=q2=設計圖:移形的暗影卓奈石", "=ds=#p12# (315)" },
        { 23136, "INV_Scroll_06", "=q2=設計圖:夜光的火石榴石", "=ds=#p12# (305)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Weapon_Shortblade_31", "=q6=#r3#", "" },
        { 29457, "INV_Weapon_ShortBlade_08", "=q3=地獄碎刺", "=ds=#h3#, #w4#" },
        { 29456, "INV_Sword_Draenei_01", "=q3=伊斯利的禮物", "=ds=#h3#, #w10#" },
        { 29118, "INV_Misc_Bag_10_Black", "=q3=走私者彈藥包", "=ds=#m14# #w20# =q1=#m1# =ds=#c2#" },
        { 25733, "INV_Scroll_05", "=q3=圖樣:惡魔皮靴", "=ds=#p7# (350)" },
        { 23134, "INV_Scroll_06", "=q2=設計圖:精美的血石榴石", "=ds=#p12# (325)" },
        { 23155, "INV_Scroll_06", "=q2=設計圖:光亮的藍月石", "=ds=#p12# (325)" },
        { 23150, "INV_Scroll_06", "=q2=設計圖:厚重的黃金卓奈石", "=ds=#p12# (315)" },
        { 22552, "INV_Scroll_03", "=q1=公式:附魔武器 - 極效打擊", "=ds=#p4# (340)" },
        { 25908, "INV_Scroll_03", "=q1=設計圖:迅捷的天火鑽石", "=ds=#p12# (365)" },
        { 25902, "INV_Scroll_03", "=q1=設計圖:強力的大地風暴鑽石", "=ds=#p12# (365) (#z12#)" },
        { 24314, "INV_Scroll_03", "=q1=圖樣:寶石包", "=ds=#p8# (340)" },
        };
        
    Consortium2 = {
        { 0, "INV_Weapon_Shortblade_31", "=q6=#r4#", "" },
        { 29117, "INV_Chest_Cloth_08", "=q3=風暴之尖外衣", "=ds=#s5#, #a1#" },
        { 29116, "INV_Pants_02", "=q3=牧民護腿", "=ds=#s11#, #a2#" },
        { 29115, "INV_Weapon_Rifle_07", "=q3=聯合團爆破槍", "=ds=#w5#" },
        { 24178, "INV_Scroll_05", "=q3=設計圖:零符吊飾", "=ds=#p12# (360)" },
        { 33156, "INV_Scroll_05", "=q3=Design: Crimson Sun", "=ds=#p12# (360) (Patch 2.2)" },
        { 25734, "INV_Scroll_05", "=q3=圖樣:惡魔皮護腿", "=ds=#p7# (350)" },
        { 33305, "INV_Scroll_05", "=q3=Design: Don Julio's Heart", "=ds=#p12# (360) (Patch 2.2)" },
        { 22535, "INV_Misc_Note_01", "=q1=公式:附魔戒指 - 力量武器", "=ds=#p4# (360) (#z12#)" },
        { 23874, "INV_Scroll_03", "=q1=結構圖:元素爆鹽炸彈", "=ds=#p5# (350)" },
        { 25903, "INV_Scroll_03", "=q1=設計圖:振奮的大地風暴鑽石", "=ds=#p12# (365) (#z12#)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Weapon_Shortblade_31", "=q6=#r5#", "" },
        { 29122, "INV_Helmet_30", "=q4=虛空行者斗篷", "=ds=#s1#, #a1#" },
        { 29119, "INV_Jewelry_Necklace_29Naxxramas", "=q4=哈拉瑪德的便宜貨", "=ds=#s2#" },
        { 29121, "INV_Weapon_Shortblade_31", "=q4=科瑞希的狡猾小刀", "=ds=#h1#, #w4#" },
        { 32412, "INV_Scroll_05", "=q3=設計圖:堅韌的大地風暴鑽石", "=ds=#p12# (365)" },
        { 31776, "INV_Shirt_GuildTabard_01", "=q1=聯合團紋章戰袍", "=ds=#s7#" },
        };

    Darkmoon1 = {
        { 19491, "INV_Jewelry_Necklace_14", "=q4=暗月護符", "=ds=#s2#", "", "1200", "#darkmoon#"},   
        { 19426, "INV_Jewelry_Necklace_16", "=q4=暗月寶珠", "=ds=#s2#", "", "1200", "#darkmoon#"},
        { 19296, "INV_Misc_Bag_21", "=q2=一等暗月獎", "", "", "40", "#darkmoon#" },
        { 19297, "INV_Misc_Bag_07_Black", "=q2=二等暗月獎", "", "", "12", "#darkmoon#" },
        { 19298, "INV_Misc_Bag_04", "=q2=三等暗月獎", "", "", "5", "#darkmoon#" },
        { 19291, "INV_Box_04", "=q1=暗月收藏箱", "", "", "50", "#darkmoon#" },
        { 19293, "INV_Misc_Food_18", "=q1=去年的羊肉", "=ds=#h1#, #w6#", "", "50", "#darkmoon#" },
        { 22729, "INV_Scroll_03", "=q1=結構圖:蒸汽坦克遙控器", "=ds=#p5# (275)", "", "40", "#darkmoon#" },
        { 19292, "INV_Misc_Food_18", "=q1=上個月的羊肉", "=ds=#h1#, #w6#", "", "10", "#darkmoon#" },
        { 19295, "INV_Misc_Herb_19", "=q1=暗月之花", "=ds=#s15#", "", "5", "#darkmoon#" },
        { 0, "", "", "" },
        { 19182, "INV_Misc_Ticket_Darkmoon_01", "=q1=暗月獎品彩票", "=ds=#m17#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 19303, "INV_Jewelry_Necklace_11", "=q3=暗月項鍊", "=ds=#s2#" },
        { 19302, "INV_Jewelry_Ring_34", "=q3=暗月戒指", "=ds=#s13#" },
        { 0, "", "", "" },
        { 11026, "INV_Crate_02", "=q1=樹蛙盒", "=ds=#e13#" },
        { 11027, "INV_Crate_02", "=q1=林蛙盒", "=ds=#e13#" },
        { 19450, "INV_Egg_04", "=q1=加布林的小窩", "=q1=#m4#: =ds=#e13#" }, 
        };

    Darkmoon2 = {
        { 19228, "INV_Misc_Ticket_Tarot_Stack_01", "=q4=野獸套牌", "=ds=#m2#" },
        { 19288, "INV_Misc_Ticket_Tarot_BlueDragon_01", "=q4=暗月卡:藍龍", "=q1=#m4#: =ds=#s14#"},
        { 0, "", "", "" },
        { 19267, "INV_Misc_Ticket_Tarot_Stack_01", "=q4=元素套牌", "=ds=#m2#" },
        { 19289, "INV_Misc_Ticket_Tarot_Maelstrom_01", "=q4=暗月卡:漩渦", "=q1=#m4#: =ds=#s14#"},
        { 0, "", "", "" },
        { 19257, "INV_Misc_Ticket_Tarot_Stack_01", "=q4=督軍套牌", "=ds=#m2#" },
        { 19287, "INV_Misc_Ticket_Tarot_Heroism_01", "=q4=暗月卡:英雄", "=q1=#m4#: =ds=#s14#"},
        { 0, "", "", "" },
        { 19277, "INV_Misc_Ticket_Tarot_Stack_01", "=q4=傳送門套卡", "=ds=#m2#" },
        { 19290, "INV_Misc_Ticket_Tarot_TwistingNether_01", "=q4=暗月卡:地獄", "=q1=#m4#: =ds=#s14#"},
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 31907, "INV_Misc_Ticket_Tarot_Stack_01", "=q4=狂怒套卡", "=ds=#m2#" },
        { 31858, "INV_Misc_Ticket_Tarot_Vengeance", "=q4=暗月卡:復仇", "=q1=#m4#: =ds=#s14#" },
        { 0, "", "", "" },
        { 31891, "INV_Misc_Ticket_Tarot_Stack_01", "=q4=風暴套卡", "=ds=#m2#" },
        { 31857, "INV_Misc_Ticket_Tarot_Wrath", "=q4=暗月卡:狂怒", "=q1=#m4#: =ds=#s14#" },
        { 0, "", "", "" },
        { 31890, "INV_Misc_Ticket_Tarot_Stack_01", "=q4=祝福套卡", "=ds=#m2#" },
        { 31856, "INV_Misc_Ticket_Tarot_Crusade", "=q4=暗月卡:聖戰", "=q1=#m4#: =ds=#s14#" },
        { 0, "", "", "" },
        { 31914, "INV_Misc_Ticket_Tarot_Stack_01", "=q4=失心套卡", "=ds=#m2#" },
        { 31859, "INV_Misc_Ticket_Tarot_Madness", "=q4=暗月卡:瘋狂", "=q1=#m4#: =ds=#s14#" },
        };

    Frostwolf1 = {
        { 17909, "INV_Jewelry_FrostwolfTrinket_05", "=q4=6級霜狼勳章", "=ds=#s14#, =q1=#r5#" },
        { 17908, "INV_Jewelry_FrostwolfTrinket_04", "=q3=5級霜狼勳章", "=ds=#s14#, =q1=#r5#" },
        { 17907, "INV_Jewelry_FrostwolfTrinket_03", "=q3=4級霜狼勳章", "=ds=#s14#, =q1=#r4#" },
        { 17906, "INV_Jewelry_FrostwolfTrinket_02", "=q2=3級霜狼勳章", "=ds=#s14#, =q1=#r3#" },
        { 17905, "INV_Jewelry_FrostwolfTrinket_01", "=q2=2級霜狼勳章", "=ds=#s14#, =q1=#r2#" },
        { 17690, "INV_Jewelry_FrostwolfTrinket_01", "=q2=1級霜狼徽記", "=ds=#s14#, =q1=#r1#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 20648, "INV_Hammer_22", "=q3=冰冷鑄錘", "=q1=#m4#: =ds=#h3#, #w6#" },
        { 19106, "INV_Spear_04", "=q3=冰刺長矛", "=q1=#m4#: =ds=#w7#" },
        { 19108, "INV_Wand_01", "=q3=骨寒魔杖", "=q1=#m4#: =ds=#w12#" },
        { 19107, "INV_Weapon_Crossbow_07", "=q3=覓血者", "=q1=#m4#: =ds=#w3#" },
        };

    GelkisClan1 = {
        { 0, "INV_Misc_Head_Centaur_01", "=q6=#r2#", "" },
        { 6773, "INV_Chest_Chain_07", "=q2=吉爾吉斯鍊甲", "=q1=#m4#: =ds=#s5#, #a3#" },
        { 6774, "INV_Wand_03", "=q2=烏泰克的手指", "=q1=#m4#: =ds=#s15#" },
        };

    HonorHold1 = {
        { 0, "INV_BannerPVP_02", "=q6=#r2#", "" },
        { 29213, "INV_Scroll_05", "=q3=圖樣:惡魔捕獵者腰帶", "=ds=#p7# (350)" },
        { 23142, "INV_Scroll_06", "=q2=設計圖:耐久的翠綠橄欖石", "=ds=#p12# (315)" },
        { 22531, "INV_Misc_Note_01", "=q1=公式:附魔護腕 - 超強治療", "=ds=#p4# (325)" },
        { 24007, "INV_Drink_Waterskin_05", "=q1=步兵水袋", "=ds=#e4#" },
        { 24008, "INV_Mushroom_01", "=q1=乾蘑菇", "=ds=#e3#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_BannerPVP_02", "=q6=#r3#", "" },
        { 25826, "INV_Jewelry_Ring_11", "=q3=賢者之戒", "=ds=#s13#" },
        { 25825, "INV_Sword_20", "=q3=步兵長劍", "=ds=#h1#, #w10#" },
        { 29214, "INV_Scroll_05", "=q3=圖樣:惡魔捕獵者護腕", "=ds=#p7# (360)" },
        { 29215, "INV_Scroll_05", "=q3=圖樣:惡魔捕獵者胸甲", "=ds=#p7# (360)" },
        { 29196, "Spell_Fire_SealOfFire", "=q2=火焰防護雕像", "=ds=#s1# #e17#" },
        { 25870, "INV_Scroll_03", "=q1=配方:轉化天火鑽石", "=ds=#p1# (350)" },
        { 22905, "INV_Scroll_03", "=q1=配方:極效敏捷藥劑", "=ds=#p1# (330)" },
        { 29719, "INV_Scroll_03", "=q1=圖樣:眼鏡蛇皮護腿片", "=ds=#p7# (335)" },
        };
        
    HonorHold2 = {
        { 0, "INV_BannerPVP_02", "=q6=#r4#", "" },
        { 29169, "INV_Jewelry_Ring_43", "=q3=恢復之戒", "=ds=#s13#" },
        { 29166, "INV_Weapon_Halberd_12", "=q3=地獄鍛造之戟", "=ds=#w7#" },
        { 32883, "INV_Misc_Ammo_Bullet_02", "=q3=地獄毀滅彈藥", "=ds=#w18#" },
        { 24180, "INV_Scroll_05", "=q3=設計圖:黎明石蟹", "=ds=#p12# (370)" },
        { 29189, "Spell_Holy_HealingAura", "=q2=恢復雕像", "=ds=#s1# #e17#" },
        { 22547, "INV_Misc_Note_01", "=q1=公式:附魔胸甲 - 特殊屬性", "=ds=#p4# (345)" },
        { 30622, "INV_Misc_Key_13", "=q1=火鑄之鑰", "=ds=#e9#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_BannerPVP_02", "=q6=#r5#", "" },
        { 29153, "INV_Weapon_ShortBlade_12", "=q4=大法師之劍", "=ds=#h3#, #w10#" },
        { 29156, "INV_Sword_11", "=q4=榮譽召喚", "=ds=#h1#, #w10#" },
        { 29151, "INV_Weapon_Rifle_02", "=q4=精兵火槍", "=ds=#w5#" },
        { 33150, "INV_Misc_Note_01", "=q3=公式:附魔披風 - 狡詐", "=ds=#p4# (300) (Patch 2.2)" },
        { 23619, "INV_Scroll_03", "=q1=設計圖:魔鋼盾刺", "=ds=#p2# (360)" },
        { 29722, "INV_Scroll_03", "=q1=圖樣:地獄眼鏡蛇護腿片", "=ds=#p7# (365)" },
        { 23999, "INV_Shirt_GuildTabard_01", "=q1=榮譽堡軍旗", "=ds=#s7#" },
        };

    KeepersofTime1 = {
        { 0, "Ability_Warrior_VictoryRush", "=q6=#r3#", "" },
        { 33160, "INV_Scroll_05", "=q3=Design: Facet of Eternity", "=ds=#p12# (360) (Patch 2.2)" },
        { 29198, "Spell_Frost_FrostArmor02", "=q2=冰霜防護雕像", "=ds=#s1# #e17#" },
        { 28272, "INV_Misc_Note_01", "=q2=公式:附魔手套 - 極效法術能量", "=ds=#p4# (360)" },
        { 22536, "INV_Misc_Note_01", "=q1=公式:附魔戒指 - 法術能量", "=ds=#p4# (360)" },
        { 25910, "INV_Scroll_03", "=q1=設計圖:謎般的天火鑽石", "=ds=#p12# (365)" },
        { 0, "", "", "" },
        { 0, "Ability_Warrior_VictoryRush", "=q6=#r4#", "" },
        { 29184, "INV_Pants_Plate_10", "=q3=時光守護者護腿", "=ds=#s11#, #a4#" },
        { 29185, "INV_Sword_11", "=q3=連續之劍", "=ds=#h3#, #w10#" },
        { 24181, "INV_Scroll_05", "=q3=設計圖:生命紅寶石巨蛇", "=ds=#p12# (370)" },
        { 24174, "INV_Scroll_05", "=q3=設計圖:霜炎吊飾", "=ds=#p12# (360)" },
        { 33158, "INV_Scroll_05", "=q3=Design: Stone of Blades", "=ds=#p12# (360) (Patch 2.2)" },
        { 29186, "Ability_Warrior_VictoryRush", "=q2=守衛者雕像", "=ds=#s1# #e17#" },
        { 30635, "INV_Misc_Key_04", "=q1=時光之鑰", "=ds=#e9#" },
        { 0, "Ability_Warrior_VictoryRush", "=q6=#r5#", "" },
        { 29183, "INV_Bracer_10", "=q4=時間行者護腕", "=ds=#s8#, #a1#" },
        { 29181, "INV_DataCrystal02", "=q4=時光流逝碎片", "=ds=#s14#" },
        { 29182, "INV_Weapon_ShortBlade_26", "=q4=裂縫分裂者", "=ds=#h1#, #w4#" },
        { 33152, "INV_Misc_Note_01", "=q3=公式:附魔手套 - 超強敏捷", "=ds=#p4# (300) (Patch 2.2)" },
        { 29713, "INV_Scroll_05", "=q3=圖樣:驚慌之鼓", "=ds=#p7# (370)" },
        { 31355, "INV_Scroll_06", "=q2=配方:超級能量精煉藥水", "=ds=#p1# (300)" },
        };

    Kurenai1 = {
        { 0, "INV_Misc_Foot_Centaur", "=q6=#r2#", "" },
        { 29217, "INV_Scroll_05", "=q3=圖樣:地獄之怒腰帶", "=ds=#p7# (340)" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Foot_Centaur", "=q6=#r3#", "" },
        { 29144, "INV_Misc_Quiver_06", "=q3=座狼皮箭袋", "=ds=#m14# #w19# =q1=#m1# =ds=#c2#" },
        { 29219, "INV_Scroll_05", "=q3=圖樣:地獄之怒護腿", "=ds=#p7# (340)" },
        { 30444, "INV_Scroll_03", "=q1=圖樣:強化礦石包", "=ds=#p7# (325)" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Foot_Centaur", "=q6=#r4#", "" },
        { 29148, "Inv_Shoulder_25", "=q3=被燻黑的皮肩甲", "=ds=#s3#, #a2#" },
        { 29142, "INV_Pants_Leather_14", "=q3=卡爾奈短裙", "=ds=#s11#, #a2#" },
        { 29146, "INV_Jewelry_Ring_35", "=q3=元素靈魂指環", "=ds=#s13#" },
        { 29218, "INV_Scroll_05", "=q3=圖樣:地獄之怒長靴", "=ds=#p7# (350)" },
        { 30443, "INV_Scroll_06", "=q2=配方:原始之火轉化原始大地", "=ds=#p1# (350)" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Foot_Centaur", "=q6=#r5#", "" },
        { 29227, "INV_Misc_Foot_Centaur", "=q4=深藍色塔巴克戰騎韁繩", "=ds=#e12#" },
        { 29229, "INV_Misc_Foot_Centaur", "=q4=銀色塔巴克戰騎韁繩", "=ds=#e12#" },
        { 29230, "INV_Misc_Foot_Centaur", "=q4=古銅色塔巴克戰騎韁繩", "=ds=#e12#" },
        { 29231, "INV_Misc_Foot_Centaur", "=q4=白色塔巴克戰騎韁繩", "=ds=#e12#" },
        { 31830, "INV_Misc_Foot_Centaur", "=q4=深藍色塔巴克坐騎韁繩", "=ds=#e12#" },
        { 31832, "INV_Misc_Foot_Centaur", "=q4=銀色塔巴克坐騎韁繩", "=ds=#e12#" },
        { 31834, "INV_Misc_Foot_Centaur", "=q4=古銅色塔巴克坐騎韁繩", "=ds=#e12#" },
        { 31836, "INV_Misc_Foot_Centaur", "=q4=白色塔巴克坐騎韁繩", "=ds=#e12#" },
        { 29140, "INV_Misc_Cape_19", "=q3=古靈披風", "=ds=#s4#" },
        { 29136, "INV_Helmet_04", "=q3=先知頭盔", "=ds=#s1#, #a3#" },
        { 29138, "INV_Mace_45", "=q3=阿爾克隆的禮物", "=ds=#h2#, #w6#" },
        { 31774, "INV_Shirt_GuildTabard_01", "=q1=卡爾奈外衣", "=ds=#s7#" },
        };

    LowerCity1 = {
        { 0, "Ability_Rogue_MasterOfSubtlety", "=q6=#r2#", "" },
        { 23138, "INV_Scroll_06", "=q2=設計圖:有用的火石榴石", "=ds=#p12# (325)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "Ability_Rogue_MasterOfSubtlety", "=q6=#r4#", "" },
        { 30836, "INV_Pants_Cloth_09", "=q3=司凱堤斯流亡護腿", "=ds=#s11#, #a1#" },
        { 30835, "INV_Chest_Plate08", "=q3=援助者胸甲", "=ds=#s5#, #a3#" },
        { 30841, "INV_Misc_Book_11", "=q3=陰鬱城祈禱者之書", "=ds=#s14#" },
        { 24179, "INV_Scroll_05", "=q3=設計圖:魔鋼野豬", "=ds=#p12# (370)" },
        { 24175, "INV_Scroll_05", "=q3=設計圖:融解吊飾", "=ds=#p12# (360)" },
        { 33157, "INV_scroll_05", "=q3=Design: Falling Star", "=ds=#p12# (360) (Patch 2.2)" },
        { 30846, "Ability_Rogue_MasterOfSubtlety", "=q2=放逐雕像", "=ds=#s1# #e17#" },
        { 22910, "INV_Scroll_06", "=q2=配方:極效暗影之力藥劑", "=ds=#p1# (350)" },
        { 30633, "INV_Misc_Key_11", "=q1=奧奇奈鑰匙", "=ds=#e9#" },
        { 0, "", "", "" },
        { 0, "Ability_Rogue_MasterOfSubtlety", "=q6=#r3#", "" },
        { 29199, "Spell_Shadow_SealOfKings", "=q2=暗影防護雕像", "=ds=#s1# #e17#" },
        { 30833, "INV_Scroll_03", "=q1=圖樣:祕法逃避披風", "=ds=#p8# (350)" },
        { 0, "", "", "" },
        { 0, "Ability_Rogue_MasterOfSubtlety", "=q6=#r5#", "" },
        { 30834, "INV_Jewelry_Ring_41", "=q4=移形者徽記", "=ds=#s13#" },
        { 30832, "INV_Hammer_08", "=q4=機密揭露之錘", "=ds=#h3#, #w6#" },
        { 30830, "INV_Spear_04", "=q4=流亡部族之戟", "=ds=#w7#" },
        { 33148, "INV_Misc_Note_01", "=q3=公式:附魔披風 - 躲閃", "=ds=#p4# (300) (Patch 2.2)" },
        { 31357, "INV_Scroll_06", "=q2=配方:多重抗性精煉藥水", "=ds=#p1# (300)" },
        { 31778, "INV_Shirt_GuildTabard_01", "=q1=陰鬱城軍服", "=ds=#s7#" },
        };

    Maghar1 = {
        { 0, "INV_Misc_Foot_Centaur", "=q6=#r2#", "" },
        { 25741, "INV_Scroll_05", "=q3=圖樣:地獄之怒腰帶", "=ds=#p7# (340)" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Foot_Centaur", "=q6=#r3#", "" },
        { 29143, "INV_Misc_Quiver_08", "=q3=裂蹄皮箭袋", "=ds=#m14# #w19# =q1=#m1# =ds=#c2#" },
        { 25742, "INV_Scroll_05", "=q3=圖樣:地獄之怒護腿", "=ds=#p7# (340)" },
        { 29664, "INV_Scroll_03", "=q1=圖樣:強化礦石包", "=ds=#p7# (325)" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Foot_Centaur", "=q6=#r4#", "" },
        { 29147, "INV_Shoulder_07", "=q3=塔巴克皮肩甲", "=ds=#s3#, #a2#" },
        { 29141, "INV_Pants_Leather_14", "=q3=暴雨護腿", "=ds=#s11#, #a2#" },
        { 29145, "INV_Jewelry_Ring_15", "=q3=先祖靈魂指環", "=ds=#s13#" },
        { 25743, "INV_Scroll_05", "=q3=圖樣:地獄之怒長靴", "=ds=#p7# (350)" },
        { 22917, "INV_Scroll_06", "=q2=配方:原始之火轉化原始大地", "=ds=#p1# (350)" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Foot_Centaur", "=q6=#r5#", "" },
        { 29102, "INV_Misc_Foot_Centaur", "=q4=深藍色塔巴克戰騎韁繩", "=ds=#e12#" },
        { 29104, "INV_Misc_Foot_Centaur", "=q4=銀色塔巴克戰騎韁繩", "=ds=#e12#" },
        { 29105, "INV_Misc_Foot_Centaur", "=q4=古銅色塔巴克戰騎韁繩", "=ds=#e12#" },
        { 29103, "INV_Misc_Foot_Centaur", "=q4=白色塔巴克戰騎韁繩", "=ds=#e12#" },
        { 31829, "INV_Misc_Foot_Centaur", "=q4=深藍色塔巴克坐騎韁繩", "=ds=#e12#" },
        { 31831, "INV_Misc_Foot_Centaur", "=q4=銀色塔巴克坐騎韁繩", "=ds=#e12#" },
        { 31833, "INV_Misc_Foot_Centaur", "=q4=古銅色塔巴克坐騎韁繩", "=ds=#e12#" },
        { 31835, "INV_Misc_Foot_Centaur", "=q4=白色塔巴克坐騎韁繩", "=ds=#e12#" },
        { 29139, "INV_Misc_Cape_06", "=q3=典禮披風", "=ds=#s4#" },
        { 29135, "INV_Helmet_17", "=q3=大地召喚者頭巾", "=ds=#s1#, #a3#" },
        { 29137, "INV_Axe_44", "=q3=地獄吼意志", "=ds=#h2#, #w1#" },
        { 31773, "INV_Shirt_GuildTabard_01", "=q1=瑪格哈軍服", "=ds=#s7#" },
        };

    MagramClan1 = {
        { 0, "INV_Misc_Head_Centaur_01", "=q6=#r2#", "" },
        { 6789, "INV_Misc_Cape_12", "=q2=半人馬葬禮毛毯", "=q1=#m4#: =ds=#s4#" },
        { 6788, "INV_Belt_11", "=q2=瑪格拉姆獵人腰帶", "=q1=#m4#: =ds=#s10#, #a2#" },
        };

    Netherwing1 = {
        { 0, "Ability_Mount_Netherdrakepurple", "=q6=#r2#", "" },
        { 32694, "INV_Misc_Gem_Sapphire_01", "=q2=工頭的徽章", "=ds=#s14#" },
        { 0, "", "", "" },
        { 0, "Ability_Mount_Netherdrakepurple", "=q6=#r3#", "" },
        { 32695, "INV_Misc_Gem_Sapphire_01", "=q3=隊長的徽章", "=ds=#s14#" },
        { 32863, "INV_Misc_Crop_01", "=q3=破天者皮鞭", "=q1=#m4#: =ds=#s14#" },
        { 0, "", "", "" },
        { 0, "Ability_Mount_Netherdrakepurple", "=q6=#r4#", "" },
        { 32864, "INV_Misc_Gem_Sapphire_01", "=q3=指揮官徽章", "=ds=#s14#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "Ability_Mount_Netherdrakepurple", "=q6=#r5#", "" },
        { 32858, "Ability_Mount_Netherdrakepurple", "=q4=藍色虛空之翼雛龍韁繩", "=ds=#e12#" },
        { 32859, "Ability_Mount_Netherdrakepurple", "=q4=深藍色虛空之翼雛龍韁繩", "=ds=#e12#" },
        { 32857, "Ability_Mount_Netherdrakepurple", "=q4=粉色虛空之翼雛龍韁繩", "=ds=#e12#" },
        { 32860, "Ability_Mount_Netherdrakepurple", "=q4=紫色虛空之翼雛龍韁繩", "=ds=#e12#" },
        { 32861, "Ability_Mount_Netherdrakepurple", "=q4=維利丹虛空之翼雛龍韁繩", "=ds=#e12#" },
        { 32862, "Ability_Mount_Netherdrakepurple", "=q4=紫羅蘭虛空之翼雛龍韁繩", "=ds=#e12#" },
        };

    Ogrila1 = {
        { 0, "INV_DataCrystal01", "=q6=#r3#", "" },
        { 32784, "INV_Potion_52", "=q1=紅色巨魔啤酒", "=ds=#e4#", "", "2", "#ogrilashard#" },
        { 32783, "INV_Potion_73", "=q1=藍色巨魔啤酒", "=ds=#e4#", "", "3", "#ogrilashard#" },
        { 0, "", "", "" },
        { 0, "INV_DataCrystal01", "=q6=#r4#", "" },
        { 32653, "INV_Misc_Cape_08", "=q3=頂尖披風", "=ds=#s4#", "", "1", "#ogrilacrystal#", "50", "#ogrilashard#" },
        { 32654, "INV_DataCrystal01", "=q3=晶鑄墜飾", "=ds=#s14#", "", "1", "#ogrilacrystal#", "50", "#ogrilashard#" },
        { 32652, "INV_Shield_30", "=q3=歐格利拉護盾", "=ds=#w8#", "", "1", "#ogrilacrystal#", "50", "#ogrilashard#" },
        { 32650, "INV_Wand_14", "=q3=天藍水晶魔杖", "=ds=#w12#", "", "1", "#ogrilacrystal#", "50", "#ogrilashard#" },
        { 0, "", "", "" },
        { 32572, "INV_Misc_Apexis_Crystal", "=q3=頂尖水晶", "=ds=#m17#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_DataCrystal01", "=q6=#r5#", "" },
        { 32647, "INV_Bracer_13", "=q4=鑲殼護腕", "=ds=#s8#, #a2#", "", "4", "#ogrilacrystal#", "100", "#ogrilashard#" },
        { 32648, "INV_Boots_Plate_02", "=q4=漩渦行走長靴", "=ds=#s12#, #a4#", "", "4", "#ogrilacrystal#", "100", "#ogrilashard#" },
        { 32651, "INV_Misc_Orb_04", "=q4=啟示水晶寶珠", "=ds=#s15#", "", "4", "#ogrilacrystal#", "100", "#ogrilashard#" },
        { 32645, "INV_Weapon_Crossbow_14", "=q4=結晶十字弩", "=ds=#w3#", "", "4", "#ogrilacrystal#", "100", "#ogrilashard#" },
        { 32828, "INV_Shirt_GuildTabard_01", "=q1=歐格利拉徽章", "=ds=#s7#", "", "10", "#ogrilashard#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 32569, "INV_Misc_Apexis_Shard", "=q1=頂尖碎片", "=ds=#m17#" },
        };  

    Scryer1 = {
        { 0, "Spell_Holy_ChampionsBond", "=q6=#r2#", "" },
        { 23133, "INV_Scroll_06", "=q2=設計圖:符文血石榴石", "=ds=#p12# (315)" },
        { 23597, "INV_Scroll_03", "=q1=設計圖:附魔艾曼泰腰帶", "=ds=#p2# (355)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "Spell_Holy_ChampionsBond", "=q6=#r3#", "" },
        { 28907, "Ability_DualWield", "=q2=劍刃銘文", "=ds=#s3# #e17#" },
        { 28908, "Spell_Holy_ChampionsBond", "=q2=騎士銘文", "=ds=#s3# #e17#" },
        { 28904, "Spell_Holy_SpiritualGuidence", "=q2=神諭銘文", "=ds=#s3# #e17#" },
        { 28903, "INV_Misc_Orb_04", "=q2=寶珠銘文", "=ds=#s3# #e17#" },
        { 23143, "INV_Scroll_06", "=q2=設計圖:燦爛的翠綠橄欖石", "=ds=#p12# (325)" },
        { 23598, "INV_Scroll_03", "=q1=設計圖:附魔艾曼泰長靴", "=ds=#p2# (355)" },
        { 29701, "INV_Scroll_03", "=q1=圖樣:附魔裂蹄長靴", "=ds=#p7# (350)" },
        { 29682, "INV_Scroll_03", "=q1=圖樣:附魔魔鱗護手", "=ds=#p7# (350)" },
        { 24292, "INV_Scroll_03", "=q1=圖樣:神秘法術絲線", "=ds=#p8# (335)" },
        };

    ScaleSands1 = {
        { 29298, "INV_Jewelry_Ring_54", "=q4=永恆指環", "=ds=#s13#, =q1=#r2#" },
        { 29299, "INV_Jewelry_Ring_54", "=q4=永恆指環", "=ds=#s13#, =q1=#r3#" },
        { 29300, "INV_Jewelry_Ring_54", "=q4=永恆指環", "=ds=#s13#, =q1=#r4#" },
        { 29301, "INV_Jewelry_Ring_55", "=q4=永恆勇士指環", "=ds=#s13#, =q1=#r5#" },
        { 0, "", "", "" },
        { 29294, "INV_Jewelry_Ring_54", "=q4=永恆指環", "=ds=#s13#, =q1=#r2#" },
        { 29295, "INV_Jewelry_Ring_54", "=q4=永恆指環", "=ds=#s13#, =q1=#r3#" },
        { 29296, "INV_Jewelry_Ring_54", "=q4=永恆指環", "=ds=#s13#, =q1=#r4#" },
        { 29297, "INV_Jewelry_Ring_55", "=q4=永恆防禦者指環", "=ds=#s13#, =q1=#r5#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 29302, "INV_Jewelry_Ring_54", "=q4=永恆指環", "=ds=#s13#, =q1=#r2#" },
        { 29303, "INV_Jewelry_Ring_54", "=q4=永恆指環", "=ds=#s13#, =q1=#r3#" },
        { 29304, "INV_Jewelry_Ring_54", "=q4=永恆指環", "=ds=#s13#, =q1=#r4#" },
        { 29305, "INV_Jewelry_Ring_55", "=q4=永恆聖人指環", "=ds=#s13#, =q1=#r5#" },
        { 0, "", "", "" },
        { 29307, "INV_Jewelry_Ring_54", "=q4=永恆指環", "=ds=#s13#, =q1=#r2#" },
        { 29306, "INV_Jewelry_Ring_54", "=q4=永恆指環", "=ds=#s13#, =q1=#r3#" },
        { 29308, "INV_Jewelry_Ring_54", "=q4=永恆指環", "=ds=#s13#, =q1=#r4#" },
        { 29309, "INV_Jewelry_Ring_55", "=q4=永恆修復者指環", "=ds=#s13#, =q1=#r5#" },
        };

    ScaleSands2 = {
        { 0, "INV_Misc_MonsterScales_13", "=q6=#r2#", "" },
        { 32274, "INV_Scroll_04", "=q4=設計圖:清晰的深紅尖晶石", "=ds=#p12# (375)" },
        { 32283, "INV_Scroll_04", "=q4=設計圖:明亮的深紅尖晶石", "=ds=#p12# (375)" },
        { 32277, "INV_Scroll_04", "=q4=設計圖:雅緻的深紅尖晶石", "=ds=#p12# (375)" },
        { 32282, "INV_Scroll_04", "=q4=設計圖:符文深紅尖晶石", "=ds=#p12# (375)" },
        { 32284, "INV_Scroll_04", "=q4=設計圖:精巧的深紅尖晶石", "=ds=#p12# (375)" },
        { 32281, "INV_Scroll_04", "=q4=設計圖:淚珠深紅尖晶石", "=ds=#p12# (375)" },
        { 32290, "INV_Scroll_04", "=q4=設計圖:明亮的獅眼石", "=ds=#p12# (375)" },
        { 32291, "INV_Scroll_04", "=q4=設計圖:閃爍的獅眼石", "=ds=#p12# (375)" },
        { 32293, "INV_Scroll_04", "=q4=設計圖:光滑的獅眼石", "=ds=#p12# (375)" },
        { 32294, "INV_Scroll_04", "=q4=設計圖:有厚度的獅眼石", "=ds=#p12# (375)" },
        { 32288, "INV_Scroll_04", "=q4=設計圖:光亮的蒼穹藍寶石", "=ds=#p12# (375)" },
        { 32286, "INV_Scroll_04", "=q4=設計圖:堅固的蒼穹藍寶石", "=ds=#p12# (375)" },
        { 32287, "INV_Scroll_04", "=q4=設計圖:發光的蒼穹藍寶石", "=ds=#p12# (375)" },
        { 32300, "Inv_Scroll_04", "=q4=設計圖:能量影歌紫水晶", "=ds=#p12# (375)" },
        { 0, "INV_Misc_MonsterScales_13", "=q6=#r3#", "" },
        { 32299, "INV_Scroll_04", "=q4=設計圖:平衡影歌紫水晶", "=ds=#p12# (375)" },
        { 32301, "INV_Scroll_04", "=q4=設計圖:鮮艷影歌紫水晶", "=ds=#p12# (375)" },
        { 32311, "INV_Scroll_04", "=q4=設計圖:燦爛的海泉綠寶石", "=ds=#p12# (375)" },
        { 32312, "INV_Scroll_04", "=q4=設計圖:尖突的海泉綠寶石", "=ds=#p12# (375)" },
        { 32310, "INV_Scroll_04", "=q4=設計圖:發光的海泉綠寶石", "=ds=#p12# (375)" },
        { 32306, "INV_Scroll_04", "=q4=設計圖:閃爍焚石", "=ds=#p12# (375)" },
        { 32305, "INV_Scroll_04", "=q4=設計圖:光輝焚石", "=ds=#p12# (375)" },
        { 32304, "INV_Scroll_04", "=q4=設計圖:強力焚石", "=ds=#p12# (375)" },
        { 31737, "INV_Misc_Ammo_Arrow_04", "=q4=永恆之箭", "=ds=#w17#" },
        { 31735, "INV_Misc_Ammo_Bullet_02", "=q4=永恆貝殼", "=ds=#w18#" },
        { 32302, "INV_Scroll_04", "=q4=設計圖:皇家影歌紫水晶", "=ds=#p12# (375), #r4#" },
        { 32309, "INV_Scroll_04", "=q4=設計圖:持久的海泉綠寶石", "=ds=#p12# (375), #r4#" },
        { 32308, "INV_Scroll_04", "=q4=設計圖:邪惡焚石", "=ds=#p12# (375), #r4#" },
        { 22538, "INV_Misc_Note_01", "=q1=公式:附魔戒指 - 屬性", "=ds=#p4# (375), #r4#" },
        };       

    Scryer2 = {      
        { 0, "Spell_Holy_ChampionsBond", "=q6=#r4#", "" },
        { 29131, "INV_Pants_Leather_18", "=q3=保持者護腿", "=ds=#s11#, #a2# " },
        { 29134, "INV_Gauntlets_26", "=q3=命定護手", "=ds=#s9#, #a4# " },
        { 29132, "INV_Misc_Gem_Bloodstone_02", "=q3=占卜者血寶石", "=ds=#s14#" },
        { 29133, "INV_Staff_38", "=q3=先知法杖", "=ds=#w9#" },
        { 24176, "INV_Scroll_05", "=q3=設計圖:枯萎吊飾", "=ds=#p12# (360)" },
        { 22908, "INV_Scroll_06", "=q2=配方:極效火焰之力藥劑", "=ds=#p1# (345)" },
        { 23599, "INV_Scroll_03", "=q1=設計圖:附魔艾曼泰胸甲", "=ds=#p2# (360)" },
        { 29700, "INV_Scroll_03", "=q1=圖樣:附魔裂蹄護手", "=ds=#p7# (350)" },
        { 29684, "INV_Scroll_03", "=q1=圖樣:附魔魔鱗長靴", "=ds=#p7# (350)" },
        { 25722, "INV_Scroll_03", "=q1=圖樣:博學者護甲片", "=ds=#p7# (325)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "Spell_Holy_ChampionsBond", "=q6=#r5#", "" },
        { 29126, "INV_Jewelry_Ring_52Naxxramas", "=q4=先知徽章", "=ds=#s13#" },
        { 29125, "INV_Weapon_Shortblade_29", "=q4=保持者之刃", "=ds=#h1#, #w4#" },
        { 28910, "Spell_Holy_WeaponMastery", "=q3=強效劍之銘文", "=ds=#s3# #e17#" },
        { 28911, "Spell_Holy_ChampionsGrace", "=q3=強效騎士銘文", "=ds=#s3# #e17#" },
        { 28912, "Spell_Holy_PowerInfusion", "=q3=強效神諭銘文", "=ds=#s3# #e17#" },
        { 28909, "INV_Misc_Orb_03", "=q3=強效寶珠銘文", "=ds=#s3# #e17#" },
        { 23600, "INV_Scroll_03", "=q1=設計圖:附魔艾曼泰護腿", "=ds=#p2# (365)" },
        { 29698, "INV_Scroll_03", "=q1=圖樣:附魔裂蹄護腿", "=ds=#p7# (350)" },
        { 29677, "INV_Scroll_03", "=q1=圖樣:附魔魔鱗護腿", "=ds=#p7# (350)" },
        { 24294, "INV_Scroll_03", "=q1=圖樣:符文法術絲線", "=ds=#p8# (375)" },
        { 31780, "INV_Shirt_GuildTabard_01", "=q1=占卜者軍服", "=ds=#s7#" },
        };

    Shatar1 = {
        { 0, "Spell_Nature_LightningOverload", "=q6=#r2#", "" },
        { 25904, "INV_Scroll_03", "=q1=設計圖:洞察的大地風暴鑽石", "=ds=#p12# (365)" },
        { 0, "", "", "" },
        { 0, "Spell_Nature_LightningOverload", "=q6=#r4#", "" },
        { 29180, "INV_Belt_08", "=q3=神聖鱗片腰帶", "=ds=#s10#, #a3#" },
        { 29179, "INV_Misc_ElvenCoins", "=q3=希瑞的禮物", "=ds=#s14#" },
        { 24182, "INV_Scroll_05", "=q3=設計圖:泰拉寶石貓頭鷹", "=ds=#p12# (370)" },
        { 33159, "INV_scroll_05", "=q3=Design: Blood of Amber", "=ds=#p12# (360) (Patch 2.2)" },
        { 29191, "Spell_Nature_LightningOverload", "=q2=力量雕像", "=ds=#s1# #e17#" },
        { 22915, "INV_Scroll_06", "=q2=配方:原始空氣轉化原始之火", "=ds=#p1# (350)" },
        { 28281, "INV_Misc_Note_01", "=q2=公式:附魔武器 - 極效治療", "=ds=#p4# (350)" },
        { 13517, "INV_Scroll_03", "=q1=配方:煉金石", "=ds=#p1# (350)" },
        { 22537, "INV_Misc_Note_01", "=q1=公式:附魔戒指 - 治療能量", "=ds=#p4# (370)" },
        { 30634, "INV_Misc_Key_09", "=q1=扭曲鍛造鑰匙", "=ds=#e9#" },
	{ 0, "", "", "" },
        { 0, "Spell_Nature_LightningOverload", "=q6=#r3#", "" },
        { 30826, "INV_Scroll_05", "=q3=設計圖:祕法護盾戒指", "=ds=#p12# (360)" },
        { 33155, "INV_scroll_05", "=q3=Design: Kailee's Rose", "=ds=#p12# (360) (Patch 2.2)" },
        { 29195, "Spell_Arcane_ArcaneResilience", "=q2=秘法防護雕像", "=ds=#s1# #e17#" },
        { 28273, "INV_Misc_Note_01", "=q2=公式:附魔手套 - 極效治療", "=ds=#p4# (350)" },
        { 0, "", "", "" },
        { 0, "Spell_Nature_LightningOverload", "=q6=#r5#", "" },
        { 29177, "INV_Jewelry_Ring_48Naxxramas", "=q4=阿達歐的命令", "=ds=#s13#" },
        { 29175, "INV_Hammer_04", "=q4=純淨光明之錘", "=ds=#h3#, #w6#" },
        { 29176, "INV_Shield_30", "=q4=薩塔羽飾", "=ds=#w8#" },
        { 33153, "INV_misc_note_01", "=q3=公式:附魔手套 - 威脅", "=ds=#p4# (300) (Patch 2.2)" },
        { 29717, "INV_Scroll_05", "=q3=圖樣:戰鬥之鼓", "=ds=#p7# (365)" },
        { 31354, "INV_Scroll_06", "=q2=配方:泰坦精煉藥水", "=ds=#p1# (300)" },
        { 31781, "INV_Shirt_GuildTabard_01", "=q1=薩塔軍服", "=ds=#s7#" },
        };

    Skyguard1 = {
        { 0, "INV_Misc_Ribbon_01", "=q6=#r2#", "" },
        { 32722, "INV_Drink_09", "=q1=濃縮泰魯草汁", "=ds=#e4#" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Ribbon_01", "=q6=#r3#", "" }, 
        { 32721, "INV_Misc_Food_63", "=q1=空防口糧", "=ds=#e3#" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Ribbon_01", "=q6=#r4#", "" },
        { 32539, "INV_Misc_Cape_08", "=q3=空防斗篷", "=ds=#s4#" },
        { 32538, "INV_Misc_Cape_05", "=q3=飛天女巫披風", "=ds=#s4#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Ribbon_01", "=q6=#r5#", "" },
        { 32770, "INV_Jewelry_Talisman_06", "=q4=空防銀十字徽章", "=ds=#s14#" },
        { 32771, "INV_Misc_Ribbon_01", "=q4=勇敢空軍綬帶", "=ds=#s14#" },
        { 32319, "Ability_Hunter_Pet_NetherRay", "=q4=藍色虛空鰭刺坐騎", "=ds=#e12#" },
        { 32314, "Ability_Hunter_Pet_NetherRay", "=q4=綠色虛空鰭刺坐騎", "=ds=#e12#" },
        { 32317, "Ability_Hunter_Pet_NetherRay", "=q4=紅色虛空鰭刺坐騎", "=ds=#e12#" },
        { 32316, "Ability_Hunter_Pet_NetherRay", "=q4=紫色虛空鰭刺坐騎", "=ds=#e12#" },
        { 32318, "Ability_Hunter_Pet_NetherRay", "=q4=銀色虛空鰭刺坐騎", "=ds=#e12#" },
        { 32445, "INV_Shirt_GuildTabard_01", "=q1=空防大衣", "=ds=#s7#" },
        };  

    Sporeggar1 = {
        { 0, "INV_Mushroom_10", "=q6=#r2#", "" },
        { 27689, "INV_Scroll_03", "=q1=食譜:小孢子點心", "=ds=#p3# (310)", "", "2", "#glowcap#" },
        { 30156, "INV_Scroll_03", "=q1=食譜:蛤蜊條", "=ds=#p3# (300)", "", "1", "#glowcap#" },
        { 25548, "INV_Mushroom_10", "=q1=長梗蘑菇", "=ds=#e3#", "", "1", "#glowcap#" },
        { 24539, "INV_Mushroom_01", "=q1=沼澤地衣", "=ds=#e3#", "", "2", "#glowcap#" },
        { 0, "", "", "" },
        { 0, "INV_Mushroom_10", "=q6=#r3#", "" },
        { 25827, "INV_Misc_Cape_17", "=q3=覆泥披風", "=ds=#s4#", "", "25", "#glowcap#" },
        { 25828, "INV_Shield_21", "=q3=石化地衣防禦者", "=ds=#w8#", "", "15", "#glowcap#" },
        { 25550, "INV_Mushroom_07", "=q1=紅帽傘菌", "=ds=#e3#", "", "1", "#glowcap#" },
        { 0, "", "", "" },
        { 24245, "INV_Mushroom_02", "=q1=白閃菇", "=ds=#m17#", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Mushroom_10", "=q6=#r4#", "" },
        { 29150, "INV_Weapon_ShortBlade_08", "=q3=硬化石碎片", "=ds=#h1#, #w4#", "", "45", "#glowcap#" },
        { 29149, "INV_Staff_02", "=q3=孢子火焰魔杖", "=ds=#w12#", "", "20", "#glowcap#" },
        { 22916, "INV_Scroll_06", "=q2=配方:原始大地轉化原始之水", "=ds=#p1# (350)", "", "25", "#glowcap#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Mushroom_10", "=q6=#r5#", "" },
        { 22906, "INV_Scroll_06", "=q2=配方:漸隱藥水", "=ds=#p1# (335)", "", "30", "#glowcap#" },
        { 31775, "INV_Shirt_GuildTabard_01", "=q1=斯博格爾大衣", "=ds=#s7#" },
        };

    Stormpike1 = {
        { 17904, "INV_Jewelry_StormPikeTrinket_05", "=q4=6級雷矛勳章", "=ds=#s14#, =q1=#r5#" },
        { 17903, "INV_Jewelry_StormPikeTrinket_04", "=q3=5級雷矛勳章", "=ds=#s14#, =q1=#r5#" },
        { 17902, "INV_Jewelry_StormPikeTrinket_03", "=q3=4級雷矛勳章", "=ds=#s14#, =q1=#r4#" },
        { 17901, "INV_Jewelry_StormPikeTrinket_02", "=q2=3級雷矛勳章", "=ds=#s14#, =q1=#r3#" },
        { 17900, "INV_Jewelry_StormPikeTrinket_01", "=q2=2級雷矛勳章", "=ds=#s14#, =q1=#r2#" },
        { 17691, "INV_Jewelry_StormPikeTrinket_01", "=q2=1級雷矛徽記", "=ds=#s14#, =q1=#r1#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 20648, "INV_Hammer_22", "=q3=冰冷鑄錘", "=q1=#m4#: =ds=#h3#, #w6#" },
        { 19106, "INV_Spear_04", "=q3=冰刺長矛", "=q1=#m4#: =ds=#w7#" },
        { 19108, "INV_Wand_01", "=q3=骨寒魔杖", "=q1=#m4#: =ds=#w12#" },
        { 19107, "INV_Weapon_Crossbow_07", "=q3=覓血者", "=q1=#m4#: =ds=#w3#" },
        }; 

    Thorium1 = {
        { 0, "INV_Ingot_Mithril", "=q6=#r2#", "" },
        { 17051, "INV_Scroll_03", "=q3=設計圖:黑鐵護腕", "=ds=#p2# (295)" },
        { 20761, "INV_Scroll_03", "=q1=配方:轉化元素火焰", "=ds=#p1# (300)" },
        { 19444, "INV_Misc_Note_01", "=q1=公式:附魔武器 - 力量", "=ds=#p4# (290)" },
        { 17023, "INV_Scroll_03", "=q1=圖樣:熔鑄頭盔", "=ds=#p7# (300)" },
        { 17022, "INV_Scroll_03", "=q1=圖樣:熔岩犬皮靴", "=ds=#p7# (295)" },
        { 17018, "INV_Scroll_03", "=q1=圖樣:光芒手套", "=ds=#p8# (300)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Ingot_Mithril", "=q6=#r3#", "" },
        { 17060, "INV_Scroll_03", "=q3=設計圖:黑鐵戰斧", "=ds=#p2# (300)" },
        { 17059, "INV_Scroll_03", "=q3=設計圖:黑鐵利劍", "=ds=#p2# (300)" },
        { 17049, "INV_Scroll_03", "=q3=設計圖:熾熱鍊甲腰帶", "=ds=#p2# (295)" },
        { 19206, "INV_Scroll_03", "=q1=設計圖:黑鐵頭盔", "=ds=#p2# (300)" },
        { 19448, "INV_Misc_Note_01", "=q1=公式:附魔武器 - 強效精神", "=ds=#p4# (300)" },  
        { 17025, "INV_Scroll_03", "=q1=圖樣:黑色龍鱗戰靴", "=ds=#p7# (300)" },
        { 19330, "INV_Scroll_03", "=q1=圖樣:熔岩腰帶", "=ds=#p7# (300)" },
        { 17017, "INV_Scroll_03", "=q1=圖樣:光芒襯肩", "=ds=#p8# (300)" },
        { 19219, "INV_Scroll_03", "=q1=圖樣:光芒長袍", "=ds=#p8# (300)" },
        };
    
    Thorium2 = {
        { 0, "INV_Ingot_Mithril", "=q6=#r4#", "" },
        { 18592, "INV_Scroll_03", "=q4=設計圖:薩弗隆戰錘", "=ds=#p2# (300), #m4#" },
        { 17052, "INV_Scroll_03", "=q3=設計圖:黑鐵護腿", "=ds=#p2# (300)" },
        { 17053, "INV_Scroll_03", "=q3=設計圖:熾熱鍊甲護肩", "=ds=#p2# (300)" },
        { 19209, "INV_Scroll_03", "=q1=設計圖:黑色怒火", "=ds=#p2# (300)" },  
        { 19208, "INV_Scroll_03", "=q1=設計圖:黑色赦免者", "=ds=#p2# (300)" },
        { 19207, "INV_Scroll_03", "=q1=設計圖:黑鐵護手", "=ds=#p2# (300)" },
        { 19449, "INV_Misc_Note_01", "=q1=公式:附魔武器 - 強效智力", "=ds=#p4# (300)" }, 
        { 19331, "INV_Scroll_03", "=q1=圖樣:多彩護手", "=ds=#p7# (300)" },
        { 19332, "INV_Scroll_03", "=q1=圖樣:熔火犬皮腰帶", "=ds=#p7# (300)" }, 
        { 19333, "INV_Scroll_03", "=q1=圖樣:熔火腰帶", "=ds=#p7# (300)" },
        { 19220, "INV_Scroll_03", "=q1=圖樣:光芒護腿", "=ds=#p8# (300)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Ingot_Mithril", "=q6=#r5#", "" },
        { 19211, "INV_Scroll_03", "=q1=設計圖:黑色衛士", "=ds=#p2# (300)" },
        { 20040, "INV_Scroll_03", "=q1=設計圖:黑鐵長靴", "=ds=#p2# (300)" },    
        { 19210, "INV_Scroll_03", "=q1=設計圖:黑手", "=ds=#p2# (300)" },  
        { 19212, "INV_Scroll_03", "=q1=設計圖:夜幕", "=ds=#p2# (300)" },
        }; 

    Thrallmar1 = {
        { 0, "INV_BannerPVP_01", "=q6=#r2#", "" },
        { 25738, "INV_Scroll_05", "=q3=圖樣:惡魔捕獵者腰帶", "=ds=#p7# (350)" },
        { 31359, "INV_Scroll_06", "=q2=設計圖:耐久的翠綠橄欖石", "=ds=#p12# (315)" },
        { 24000, "INV_Misc_Note_01", "=q1=公式:附魔護腕 - 超強治療", "=ds=#p4# (325)" },
        { 24006, "INV_Drink_Waterskin_05", "=q1=步兵的水袋", "=ds=#e4#" },
        { 24009, "INV_Misc_Food_42", "=q1=乾果糧", "=ds=#e3#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_BannerPVP_01", "=q6=#r3#", "" },
        { 25824, "INV_Jewelry_Ring_17", "=q3=先知指環", "=ds=#s13#" },
        { 25823, "INV_Axe_11", "=q3=步兵的戰斧", "=ds=#h1#, #w1#" },
        { 25739, "INV_Scroll_05", "=q3=圖樣:惡魔捕獵者護腕", "=ds=#p7# (360)" },
        { 25740, "INV_Scroll_05", "=q3=圖樣:惡魔捕獵者胸甲", "=ds=#p7# (360)" },
        { 29197, "Spell_Fire_SealOfFire", "=q2=火焰防護雕像", "=ds=#s1# #e17#" },
        { 29232, "INV_Scroll_03", "=q1=配方:轉化天火鑽石", "=ds=#p1# (350)" },
        { 24001, "INV_Scroll_03", "=q1=配方:極效敏捷藥劑", "=ds=#p1# (330)" },
        { 31361, "INV_Scroll_03", "=q1=圖樣:眼鏡蛇皮護腿片", "=ds=#p7# (335)" },
        };
        
    Thrallmar2 = {
        { 0, "INV_BannerPVP_01", "=q6=#r4#", "" },
        { 29168, "INV_Jewelry_Ring_22", "=q3=先祖指環", "=ds=#s13#" },
        { 29167, "INV_Spear_03", "=q3=變黑的長矛", "=ds=#w7#" },
        { 32882, "INV_Misc_Ammo_Bullet_02", "=q3=地獄火射擊彈藥", "=ds=#w18#" },
        { 31358, "INV_Scroll_05", "=q3=設計圖:黎明石蟹", "=ds=#p12# (370)" },
        { 29190, "Spell_Holy_HealingAura", "=q2=恢復雕像", "=ds=#s1# #e17#" },
        { 24003, "INV_Misc_Note_01", "=q1=公式:附魔胸甲 - 特殊屬性", "=ds=#p4# (345)" },
        { 30637, "INV_Misc_Key_13", "=q1=火鑄之鑰", "=ds=#e9#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_BannerPVP_01", "=q6=#r5#", "" },
        { 29155, "INV_Weapon_ShortBlade_27", "=q4=暴風召喚者", "=ds=#h3#, #w10#" },
        { 29165, "INV_Axe_10", "=q4=戰爭使者", "=ds=#h1#, #w1#" },
        { 29152, "INV_Weapon_Bow_08", "=q4=神射手的弓", "=ds=#w2#" },
	{ 33151, "INV_Misc_Note_01", "=q3=公式:附魔披風 - 狡詐", "=ds=#p4# (300) (Patch 2.2)" }, 
        { 24002, "INV_Scroll_03", "=q1=設計圖:魔鋼盾刺", "=ds=#p2# (360)" },
        { 31362, "INV_Scroll_03", "=q1=圖樣:地獄眼鏡蛇護腿片", "=ds=#p7# (365)" },
        { 24004, "INV_Shirt_GuildTabard_01", "=q1=索爾瑪大衣", "=ds=#s7#" },
        }; 

    Timbermaw = {
        { 0, "INV_Misc_Horn_01", "=q6=#r2#", "" },
        { 13484, "INV_Scroll_03", "=q2=配方:轉土成水","=ds=#p1# (275)" },
        { 22392, "INV_Misc_Note_01", "=q1=公式:附魔雙手武器 - 敏捷","=ds=#p4# (290)" },
        { 20254, "INV_Scroll_03", "=q1=圖樣:戰熊熱褲","=ds=#p7# (285)" },   		 
   	{ 20253, "INV_Scroll_03", "=q1=圖樣:戰熊背心","=ds=#p7# (275)" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Horn_01", "=q6=#r3#", "" },
        { 16768, "INV_Misc_Bag_11", "=q2=熊怪醫療包", "=ds=#s15#" },
        { 16769, "INV_Mace_11", "=q2=熊怪醫療圖騰", "=ds=#h3#, #w6#" },
        { 19202, "INV_Scroll_03", "=q1=設計圖:重型木喉腰帶","=ds=#p2# (290)" },
        { 19445, "INV_Misc_Note_01", "=q1=公式:附魔武器 - 敏捷","=ds=#p4# (290)" },
        { 19326, "INV_Scroll_03", "=q1=圖樣:木喉之力","=ds=#p7# (290)" },
        { 19215, "INV_Scroll_03", "=q1=圖樣:木喉之智","=ds=#p8# (290)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Horn_01", "=q6=#r4#", "" },
        { 19204, "INV_Scroll_03", "=q1=設計圖:重型木喉長靴","=ds=#p2# (300)" },
        { 19327, "INV_Scroll_03", "=q1=圖樣:木喉作戰手套","=ds=#p7# (300)" },  
   	{ 19218, "INV_Scroll_03", "=q1=圖樣:木喉襯肩","=ds=#p8# (300)" },  
   	{ 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Horn_01", "=q6=#r5#", "" },        
        { 21326, "INV_Misc_Horn_01", "=q4=木喉防禦者", "=q1=#m4#: =ds=#s14#"},
        };
     
    Tranquillien1 = {
        { 0, "INV_Misc_Bandana_03", "=q6=#r2#", "" },
        { 22991, "INV_Boots_Cloth_05", "=q2=學徒長靴", "=ds=#s12#, #a1# " },
        { 22992, "INV_Boots_04", "=q2=沼澤探險者長靴", "=ds=#s12#, #a2# " },
        { 22993, "INV_Boots_01", "=q2=自願者護腿", "=ds=#s12#, #a3# " },
        { 28164, "INV_Sword_07", "=q2=寧靜之地微光巨劍", "=ds=#h2#, #w10#" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Bandana_03", "=q6=#r3#", "" },
        { 28155, "INV_Misc_Bandana_03", "=q2=藥劑師腰帶", "=ds=#s10#, #a1# " },
        { 28158, "INV_Belt_09", "=q2=蝙蝠皮腰帶", "=ds=#s10#, #a2# " },
        { 28162, "INV_Belt_03", "=q2=寧靜之地防禦者腰帶", "=ds=#s10#, #a3# " },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Bandana_03", "=q6=#r4#", "" },
        { 22986, "INV_Chest_Cloth_19", "=q2=藥劑師長袍", "=ds=#s5#, #a1# " },
        { 22987, "INV_Chest_Leather_01", "=q2=亡靈哨兵外套", "=ds=#s5#, #a2# " },
        { 22985, "INV_Chest_Chain", "=q2=炎冠胸甲", "=ds=#s5#, #a3# " },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Bandana_03", "=q6=#r5#", "" },
        { 22990, "INV_Misc_Cape_07", "=q3=寧靜之地勇者披風", "=ds=#s4#" },
        };
    
    VioletEye1 = {
        { 0, "INV_Jewelry_Ring_62", "=q6="..AL["Path of the Violet Assassin"], "" },
        { 29280, "INV_Jewelry_Ring_62", "=q3=紫羅蘭徽章", "=ds=#s13#, =q1=#r2#" },
        { 29281, "INV_Jewelry_Ring_62", "=q4=紫羅蘭徽章", "=ds=#s13#, =q1=#r3#" },
        { 29282, "INV_Jewelry_Ring_62", "=q4=紫羅蘭徽章", "=ds=#s13#, =q1=#r4#" },
        { 29283, "INV_Jewelry_Ring_62", "=q4=刺客大師之紫羅蘭徽章", "=ds=#s13#, =q1=#r5#" },
        { 0, "", "", "" },
        { 0, "INV_Jewelry_Ring_62", "=q6="..AL["Path of the Violet Mage"], "" },
        { 29284, "INV_Jewelry_Ring_62", "=q3=紫羅蘭徽章", "=ds=#s13#, =q1=#r2#" },
        { 29285, "INV_Jewelry_Ring_62", "=q4=紫羅蘭徽章", "=ds=#s13#, =q1=#r3#" },
        { 29286, "INV_Jewelry_Ring_62", "=q4=紫羅蘭徽章", "=ds=#s13#, =q1=#r4#" },
        { 29287, "INV_Jewelry_Ring_62", "=q4=大法師之紫羅蘭徽章", "=ds=#s13#, =q1=#r5#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Jewelry_Ring_62", "=q6="..AL["Path of the Violet Restorer"], "" },
        { 29288, "INV_Jewelry_Ring_62", "=q3=紫羅蘭徽章", "=ds=#s13#, =q1=#r2#" },
        { 29289, "INV_Jewelry_Ring_62", "=q4=紫羅蘭徽章", "=ds=#s13#, =q1=#r3#" },
        { 29291, "INV_Jewelry_Ring_62", "=q4=紫羅蘭徽章", "=ds=#s13#, =q1=#r4#" },
        { 29290, "INV_Jewelry_Ring_62", "=q4=偉大治療師之紫羅蘭徽章", "=ds=#s13#, =q1=#r5#" },
        { 0, "", "", "" },
        { 0, "INV_Jewelry_Ring_62", "=q6="..AL["Path of the Violet Protector"], "" },
        { 29276, "INV_Jewelry_Ring_62", "=q3=紫羅蘭徽章", "=ds=#s13#, =q1=#r2#" },
        { 29277, "INV_Jewelry_Ring_62", "=q4=紫羅蘭徽章", "=ds=#s13#, =q1=#r3#" },
        { 29278, "INV_Jewelry_Ring_62", "=q4=紫羅蘭徽章", "=ds=#s13#, =q1=#r4#" },
        { 29279, "INV_Jewelry_Ring_62", "=q4=重要保衛者之紫羅蘭徽章", "=ds=#s13#, =q1=#r5#" },
        };

    VioletEye2 = {
        { 0, "Ability_Warrior_ShieldMastery", "=q6=#r3#", "" },
        { 31113, "Spell_Holy_MindSooth", "=q4=紫羅蘭徽記", "=q1=#m4#: =ds=#s14#" },
        { 31395, "INV_Scroll_04", "=q4=設計圖:冰霜守衛頭盔", "=ds=#p2# (375)" },
        { 31393, "INV_Scroll_04", "=q4=設計圖:冰霜守衛胸甲", "=ds=#p2# (375)" },
        { 31401, "INV_Scroll_04", "=q4=設計圖:冰凍之眼", "=ds=#p12# (375)" },
        { 29187, "Ability_Warrior_ShieldMastery", "=q2=忍耐銘文", "=ds=#s3# #e17#" },
        { 0, "", "", "" },
        { 0, "Ability_Warrior_ShieldMastery", "=q6=#r4#", "" },
        { 31394, "INV_Scroll_04", "=q4=設計圖:冰霜守衛護腿", "=ds=#p2# (375)" },
        { 0, "?", "=q4=Pattern: Shadowprowler's Chestguard", "=ds=#p7# (365) (Patch 2.2)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "Ability_Warrior_ShieldMastery", "=q6=#r5#", "" },
        { 33124, "INV_Scroll_05", "=q3=Pattern: Cloak of Darkness", "=ds=#p7# (360) (Patch 2.2)" },
        { 0, "?", "=q2=Recipe: Flask of Chromatic Wonder", "=ds=#p1# (375) (Patch 2.2)" },
        { 33165, "INV_Misc_Note_01", "=q1=Formula: Enchant Weapon - Greater Agility", "=ds=#p4# (350) (Patch 2.2)" },
        };

    WaterLords1 = {
        { 0, "Spell_Frost_SummonWaterElemental_2", "=q6=#r3#", "" },
        { 18399, "INV_Jewelry_Ring_28", "=q3=海洋之風", "=q1=#m4#: =ds=#s13#" },
        { 18398, "INV_Jewelry_Ring_10", "=q3=潮汐指環", "=q1=#m4#: =ds=#s13#" },
        { 17333, "INV_Potion_76", "=q1=水之精萃", "=ds=#m3#" },
        { 0, "", "", "" },
        { 0, "Spell_Frost_SummonWaterElemental_2", "=q6=#r4#", "" },
        { 22754, "INV_Potion_83", "=q1=永恆精華", "=ds=#m3#" },
        };

    Wintersaber1 = {
        { 0, "Ability_Mount_PinkTiger", "=q6=#r5#", "" },
        { 13086, "Ability_Mount_PinkTiger", "=q4=冬泉霜刃豹韁繩", "=ds=#e12#" },
        };

    Zandalar1 = {
        { 0, "INV_Misc_Coin_08", "=q6=#r2#", "" },
        { 20012, "INV_Scroll_03", "=q1=配方:強效昏睡藥水", "=ds=#p1# (275)" },
        { 19778, "INV_Scroll_03", "=q1=設計圖:血魂護手", "=ds=#p2# (300)" },
        { 19781, "INV_Scroll_03", "=q1=設計圖:黑暗之魂護肩", "=ds=#p2# (300)" },
        { 20757, "INV_Misc_Note_01", "=q1=公式:卓越法力之油", "=ds=#p4# (300)" },
        { 20001, "INV_Scroll_03", "=q1=結構圖:血藤透鏡", "=ds=#p5# (300)" },
        { 19771, "INV_Scroll_03", "=q1=圖樣:原始蝙蝠皮護腕", "=ds=#p7# (300)" },
        { 19766, "INV_Scroll_03", "=q1=圖樣:血藤長靴", "=ds=#p8# (300)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 19858, "INV_Misc_Coin_08", "=q2=贊達拉榮譽勳章", "=ds=#m17#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Coin_08", "=q6=#r3#", "" },
        { 20014, "INV_Scroll_03", "=q1=配方:極效食人妖之血藥水", "=ds=#p1# (290)" },
        { 19777, "INV_Scroll_03", "=q1=設計圖:血魂護肩", "=ds=#p2# (300)" },
        { 19780, "INV_Scroll_03", "=q1=設計圖:黑暗之魂護腿", "=ds=#p2# (300)" },
        { 20756, "INV_Misc_Note_01", "=q1=公式:卓越巫師之油", "=ds=#p4# (300)" },
        { 20000, "INV_Scroll_03", "=q1=結構圖:血藤護目鏡", "=ds=#p5# (300)" },
        { 19773, "INV_Scroll_03", "=q1=圖樣:血虎護肩", "=ds=#p7# (300)" },
        { 19770, "INV_Scroll_03", "=q1=圖樣:原始蝙蝠皮手套", "=ds=#p7# (300)" },
        { 19765, "INV_Scroll_03", "=q1=圖樣:血藤護腿", "=ds=#p8# (300)" },
        { 20031, "INV_Misc_Food_42", "=q1=美味芒果", "=ds=#e3#", "", "1", "#zandalar#" },
        };
        
    Zandalar2 = {
        { 0, "INV_Misc_Coin_08", "=q6=#r4#", "" },
        { 20080, "INV_Potion_29", "=q2=贊札之光", "=ds=#e2#", "", "3", "#zandalar#" },
        { 20079, "INV_Potion_30", "=q2=贊札之魂", "=ds=#e2#", "", "3", "#zandalar#" },
        { 20081, "INV_Potion_31", "=q2=贊札之速", "=ds=#e2#", "", "3", "#zandalar#" },
        { 20011, "INV_Scroll_03", "=q1=配方:魔血藥水", "=ds=#p1# (275)" },
        { 19776, "INV_Scroll_03", "=q1=設計圖:血魂胸甲", "=ds=#p2# (300)" },
        { 19779, "INV_Scroll_03", "=q1=設計圖:黑暗之魂胸甲", "=ds=#p2# (300)" },
        { 19772, "INV_Scroll_03", "=q1=圖樣:血虎胸甲", "=ds=#p7# (300)" },
        { 19769, "INV_Scroll_03", "=q1=圖樣:原始蝙蝠皮外套", "=ds=#p7# (300)" },
        { 19764, "INV_Scroll_03", "=q1=圖樣:血藤外套", "=ds=#p8# (300)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Coin_08", "=q6=#r5#", "" },
        { 20077, "INV_Misc_ArmorKit_08", "=q3=贊達拉力量徽記", "=ds=#s3# #e17#", "", "15", "#zandalar#" },
        { 20076, "INV_Jewelry_Ring_46", "=q3=贊達拉魔精徽記", "=ds=#s3# #e17#", "", "15", "#zandalar#" },
        { 20078, "Spell_Holy_PowerWordShield", "=q3=贊達拉寧靜徽記", "=ds=#s3# #e17#", "", "15", "#zandalar#" },
        { 20013, "INV_Scroll_03", "=q1=配方:活力行動藥水", "=ds=#p1# (285)" },
        };
 
    };
end
